/*
 * Decompiled with CFR 0.152.
 */
package qz;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import qz.ByteArrayBuilder;
import qz.LogIt;
import qz.exception.NullCommandException;

public class FileUtilities {
    public static String[] badExtensions = new String[]{"exe", "pif", "paf", "application", "msi", "com", "cmd", "bat", "lnk", "gadget", "msp", "mst", "cpl", "scr", "ins", "hta", "msc", "jar", "jnlp", "vb", "vbs", "vbe", "js", "jse", "ws", "wsf", "wsc", "wsh", "ps1", "ps1xml", "ps2", "ps2xml", "ps1", "ps1xml", "ps2", "ps2xml", "psc1", "psc2", "msh", "msh1", "msh2", "mshxml", "msh1xml", "msh2xml", "scf", "inf", "reg", "doc", "docx", "dot", "dotx", "dotm", "xls", "xlt", "xlm", "xlsx", "xlsm", "xltx", "xltm", "xlsb", "xla", "xlam", "xll", "xlw", "ppt", "pps", "pptx", "pptm", "potx", "potm", "ppam", "ppsx", "ppsm", "sldx", "sldm", "ade", "adp", "adn", "accdb", "accdr", "accdt", "mdb", "mda", "mdn", "mdt", "mdw", "mdf", "mde", "accde", "mam", "maq", "mar", "mat", "maf", "ldb", "laccdb", "app", "action", "bin", "command", "workflow", "sh", "ksh", "csh", "pl", "py", "bash", "run", "ipa, apk", "widget", "url"};

    public static boolean isBadExtension(String fileName) {
        String[] tokens = fileName.split("\\.(?=[^\\.]+$)");
        if (tokens.length == 2) {
            String extension = tokens[1];
            for (String s : badExtensions) {
                if (!s.equalsIgnoreCase(extension)) continue;
                return true;
            }
        }
        return false;
    }

    public static byte[] readRawFile(String url) throws IOException {
        int len;
        ByteArrayBuilder rawCmds = new ByteArrayBuilder();
        byte[] buffer = new byte[512];
        DataInputStream in = new DataInputStream(new URL(url).openStream());
        while ((len = in.read(buffer)) != -1) {
            byte[] temp = new byte[len];
            System.arraycopy(buffer, 0, temp, 0, len);
            rawCmds.append(temp);
        }
        in.close();
        return rawCmds.getByteArray();
    }

    public static String readXMLFile(String url, String dataTag) throws DOMException, IOException, NullCommandException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(url);
        doc.getDocumentElement().normalize();
        LogIt.log("Root element " + doc.getDocumentElement().getNodeName());
        NodeList nodeList = doc.getElementsByTagName(dataTag);
        if (nodeList.getLength() > 0) {
            return nodeList.item(0).getTextContent();
        }
        throw new NullCommandException("Node \"" + dataTag + "\" could not be found in XML file specified");
    }
}

